const http = require("http");
const next = require("next");

const port = parseInt(process.env.PORT, 10) || 3000;
const dev = process.env.NODE_ENV !== "production";

const app = next({ dev });
const handle = app.getRequestHandler();

app
  .prepare()
  .then(() => {
    http
      .createServer((req, res) => handle(req, res))
      .listen(port, () => {
        console.log(`> Ready on port ${port} (dev=${dev})`);
      });
  })
  .catch((err) => {
    console.error("Failed to start Next server:", err);
    process.exit(1);
  });
